@include('panel.includes.header')

<div class="page has-sidebar-left height-full">
    <div class="container-fluid relative animatedParent animateOnce">
        <div class="row" style="margin: 20px 0 20px;">
            <div class="col-lg-10">
            </div>

            <div class="col-lg-2 text-right">
                <a href="{{ url('/admin/sites/create') }}" class="btn btn-warning btn-lg btn-block">Yeni Kayıt Oluştur</a>
            </div>
        </div>

        <section class="paper-card">
            <div class="row">
                <div class="col-lg-12">
                    <table id="example2" class="table table-bordered table-hover data-tables" data-page-length="25" data-order="[[ 0, &quot;desc&quot; ]]">
                        <thead>
                        <tr>
                            <th style="width: 10px">#</th>
                            <th>Site Adı</th>
                            <th>Platform</th>
                            <th>Environment</th>
                            <th>Durum</th>
                            <th>Oluşturma Tarihi</th>
                            <th>İşlemler</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($sites as $site)
                            <tr>
                                <td>{{ $site->id }}</td>
                                <td>{{ $site->name }}</td>
                                <td>{{ \App\Site::getPlatform($site->platform) }}</td>
                                <td>{{ \App\Site::getEnvironment($site->environment) }}</td>
                                <td>
                                    @if($site->status)
                                        <span class="badge text-white bg-green">Aktif</span>
                                    @else
                                        <span class="badge text-white bg-red">Pasif</span>
                                    @endif
                                </td>
                                <td>{{ $site->created_at }}</td>
                                <td>
                                    <a href="{{ url('/admin/sites/edit/' . $site->id) }}">
                                        <i class="icon-pencil"></i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
                <!-- /.col -->
        </section>
    </div>
</div>

@include('panel.includes.footer')
