@if(count($players) > 0)
    @foreach($players as $player)
        <tr>
            <td>{{ $player->id }}</td>
            <td>{{ $player->sites->name }}</td>
            <td>{{ $player->username }}</td>
            <td>{{ $player->first_name }}</td>
            <td>{{ $player->last_name }}</td>
            <td>
                @if($player->status)
                    <span class="badge text-white bg-green">Aktif</span>
                @else
                    <span class="badge text-white bg-red">Pasif</span>
                @endif
            </td>
            <td>{{ $player->created_at }}</td>
            <td>
                <a href="{{ url('/admin/players/show/' . $player->id) }}">
                    <i class="icon-eye"></i>
                </a>
            </td>
        </tr>
    @endforeach
@else
    <tr>
        <td colspan="8">Aranılan kriterlere uygun herhangi bir kayıt bulunamamıştır.</td>
    </tr>
@endif

<script type="text/javascript">
    var transactionPaginate = {
        totalRow: '{{ $players->total() }}',
        perPage: '{{ $players->perPage() }}',
        currentPage: '{{ $players->currentPage() }}',
    };
</script>
