@include('panel.includes.header')

<div class="page has-sidebar-left height-full">
    <div class="container-fluid relative animatedParent animateOnce">
        <div class="row" style="margin: 20px 0 20px;">
            <div class="col-lg-2">
                <a href="{{ url('/admin/operators?status=1') }}" class="btn btn-success btn-lg btn-block">Aktif Operatörler ({{ collect($operators)->where('status', '=', 1)->count() }})</a>
            </div>
            <div class="col-lg-2">
                <a href="{{ url('/admin/operators?status=0') }}" class="btn btn-danger btn-lg btn-block">Pasif Operatörler ({{ collect($operators)->where('status', '=', 0)->count() }})</a>
            </div>
            <div class="col-lg-6">
            </div>
            <div class="col-lg-2 text-right">
                <a href="{{ url('/admin/operators/create') }}" class="btn btn-warning btn-lg btn-block">Yeni Kayıt Oluştur</a>
            </div>
        </div>

        <section class="paper-card">
            <div class="row">
                <div class="col-lg-12">
                    <table id="example2" class="table table-bordered table-hover data-tables" data-page-length="25" data-order="[[ 0, &quot;desc&quot; ]]">
                        <thead>
                        <tr>
                            <th style="width: 10px">#</th>
                            <th>Site Adı</th>
                            <th>Kullanıcı Adı</th>
                            <th>İsim</th>
                            <th>Soyisim</th>
                            <th>E-Mail</th>
                            <th>Yetki</th>
                            <th>Durum</th>
                            <th>Google Authenticator</th>
                            <th>Oluşturma Tarihi</th>
                            <th>İşlemler</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($operators as $operator)
                            @if($status == $operator->status)
                                <tr>
                                    <td>{{ $operator->id }}</td>
                                    <td>{{ !empty($operator->api_id) ? $operator->sites->name : '-' }}</td>
                                    <td>{{ $operator->username }}</td>
                                    <td>{{ $operator->first_name }}</td>
                                    <td>{{ $operator->last_name }}</td>
                                    <td>{{ $operator->email }}</td>
                                    <td>{{ \App\User::getRole($operator->role_id) }}</td>
                                    <td>
                                        @if($operator->status)
                                            <span class="badge text-white bg-green">Aktif</span>
                                        @else
                                            <span class="badge text-white bg-red">Pasif</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($operator->ga_status)
                                            <span class="badge text-white bg-green">Aktif</span>
                                        @else
                                            <span class="badge text-white bg-red">Pasif</span>
                                        @endif
                                    </td>
                                    <td>{{ $operator->created_at }}</td>
                                    <td>
                                        <a href="{{ url('/admin/operators/edit/' . $operator->id) }}" class="btn btn-sm btn-warning">
                                            <i class="icon-pencil"></i>
                                        </a>

                                        <a href="{{ url('/admin/operators/ga/' . $operator->id) }}" class="btn btn-sm btn-dark">
                                            <i class="icon-google"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endif
                        @endforeach
                        </tbody>
                    </table>
                </div>
                <!-- /.col -->
        </section>
    </div>
</div>

@include('panel.includes.footer')
