@include('panel.includes.header')

<div class="page has-sidebar-left height-full">
    <div class="container-fluid relative animatedParent animateOnce">
        <div class="row" style="margin: 20px 0 20px;">
            <div class="col-lg-10">
                <b style="color: darkred;">Bu sayfa otomatik olarak 30 saniyede bir yenilenmektedir.</b>
            </div>

            <div class="col-lg-2 text-right">
            </div>
        </div>

        <div class="errors" style="display: none;">
            <!-- loading... -->
        </div>

        <section class="paper-card">
            <div class="row">
                <div class="col-lg-12">
                    <table id="example2" class="table table-bordered table-hover data-tables" data-page-length="25" data-order="[[ 1, &quot;asc&quot; ]]">
                        <thead>
                        <tr>
                            <th>Tip</th>
                            <th>Banka</th>
                            <th>Açıklama</th>
                            <th>Yatırım Aralığı</th>
                            <th>Hesap Sahibi</th>
                            <th>Şube Kodu</th>
                            <th>Hesap Numarası</th>
                            <th>IBAN</th>
                            <th>İşlemler</th>
                        </tr>
                        </thead>
                        <tbody>
                            @foreach($bankAccounts as $key => $value)
                                <tr>
                                    <td>{{ !empty($value['type_id']) ? \App\BankAccount::getType($value['type_id']) : '-' }}</td>
                                    <td>{{ !empty($value['bank_id']) ? \App\Bank::getBankName($value['bank_id']) : '-' }}</td>
                                    <td>{{ $value['description'] }}</td>
                                    <td>{{ !empty($value['deposit_range']) ? $value->deposit_range->name : '-' }}</td>
                                    <td>{{ $value['account_owner'] }}</td>
                                    <td>{{ $value['branch_code'] }}</td>
                                    <td>{{ $value['account_number'] }}</td>
                                    <td>{{ $value['iban'] }}</td>
                                    <td>
                                        <a href="javascript:void(0);" class="btn btn-warning" onclick="copyToClipboard('Banka: {{ !empty($value['bank_id']) ? \App\Bank::getBankName($value['bank_id']) : '-' }}\nHesap Sahibi: {{ $value['account_owner'] }}\nHesap Numarası: {{ $value['account_number'] }}\nŞube Kodu: {{ $value['branch_code'] }}\nIBAN: {{ $value['iban'] }}');">
                                            Kopyala
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </section>
    </div>
</div>

@include('panel.includes.footer')
