@if(count($apiLogs) > 0)
    @foreach($apiLogs as $log)
        @php
            if ($log->type_id === 2) {
                $responseContent = json_decode($log->response_content);

                if (!empty($responseContent) && (int)$responseContent->status === 200) {
                    $responseError = false;
                } else {
                    $responseError = true;
                }
            } else {
                $responseContent = json_decode($log->response_content);

                if (!empty($responseContent) && (int)$responseContent->code === 200) {
                    $responseError = false;
                } else {
                    $responseError = true;
                }
            }
        @endphp
        <tr class="{{ $responseError === true ? 'errorApiBg' : '' }}">
            <td class="text-center">
                @if($log->user_id !== 0)
                    <a href="/admin/operators/edit/{{ $log->user_id }}">
                        {{ $log->user->username ?? '-' }}
                    </a>
                @else
                    -
                @endif
            </td>
            <td class="text-center">
                @if($log->type_id === 1)
                    API
                @elseif($log->type_id === 2)
                    Seamless
                @else
                    -
                @endif
            </td>
            <td class="text-center">{{ $log->transaction_id }}</td>
            <td class="text-center">
                <button type="button" class="btn btn-warning btn-xs" data-toggle="modal" data-target="#requestModal_{{ $log->id }}">
                    İçeriği Gör
                </button>

                <!-- Modal -->
                <div class="modal fade" id="requestModal_{{ $log->id }}" tabindex="-1" aria-labelledby="requestModal_{{ $log->id }}_Label" aria-hidden="true">
                    <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">#{{ $log->id }} İçeriğine Ait Request JSON</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <pre class="brush: json text-left">{{ json_encode(json_decode($log->request_content), JSON_PRETTY_PRINT) }}</pre>
                            </div>
                        </div>
                    </div>
                </div>
            </td>
            <td class="text-center">
                <button type="button" class="btn btn-warning btn-xs" data-toggle="modal" data-target="#responseModal_{{ $log->id }}">
                    İçeriği Gör
                </button>

                <!-- Modal -->
                <div class="modal fade" id="responseModal_{{ $log->id }}" tabindex="-1" aria-labelledby="responseModal_{{ $log->id }}_Label" aria-hidden="true">
                    <div class="modal-dialog modal-xl">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalLabel">#{{ $log->id }} İçeriğine Ait Response JSON</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <pre class="brush: json text-left">{{ json_encode(json_decode($log->response_content), JSON_PRETTY_PRINT) }}</pre>
                            </div>
                        </div>
                    </div>
                </div>
            </td>
            <td class="text-center">{{ $log->elapsed_time }}</td>
            <td class="text-center">{{ $log->created_at }}</td>
            <td class="text-center">{{ $log->updated_at }}</td>
        </tr>
    @endforeach
@else
    <tr>
        <td colspan="8">Aranılan kriterlere uygun herhangi bir kayıt bulunamamıştır.</td>
    </tr>
@endif

<script type="text/javascript">
    var transactionPaginate = {
        totalRow: '{{ $apiLogs->total() }}',
        perPage: '{{ $apiLogs->perPage() }}',
        currentPage: '{{ $apiLogs->currentPage() }}',
    };
</script>

<style>
    .errorApiBg {
        background-color: darkred;
        color: #fff;
    }

    .errorApiBg:hover {
        background-color: darkred !important;
        color: #fff !important;
    }

    .errorApiBg a {
        text-decoration: none;
        color: #fff;
    }
</style>
