﻿window.checkAjax = [];
window.checkAjaxFunction = function(name, time, functionDefault){
	window.checkAjax[name] = window.checkAjax[name] || false;
	functionDefault = functionDefault || name;

	if(window.checkAjax[name] !== false){
		clearTimeout(window.checkAjax[name]);

		window.checkAjax[name] = false;
	}
	window.checkAjax[name] = setTimeout(functionDefault ,time);
};

$("#PaparaDeposit").submit(function() {
	$('.loader').css('display','flex');
	$.ajax(
	{
		type: "POST",
		url:  "/Methods/Papara/Pay",
		dataType: 'json',
		data : btoa(unescape(encodeURIComponent(JSON.stringify(jQuery("#PaparaDeposit").serializeArray())))),
		success : function(response){
			$('.loader').hide();
			if(response.valid == 0){
				swal.fire(response.validTitle, response.validMessage, response.validClass);
			}else{
				if(response.validCode == 200){
					swal.fire({
						type: response.validClass,
						title: response.validTitle,
						text: response.validMessage,
						showConfirmButton: false,
						allowOutsideClick: false,
						allowEscapeKey: false
					});
					window.checkAjaxFunction("PaparaCheckSession",2500,"PaparaCheckSession()");
				}
				if(response.validCode == 902){
					window.location = response.validMessage;
				}
			}
			console.log(response);
		}
	})

});

function PaparaCheckSession(first){
	first = typeof first === 'undefined' ? true : first;
	if(first === true){
		if(window.checkAjax["PaparaCheckSession"] !== false){
			clearTimeout(window.checkAjax["PaparaCheckSession"]);
			window.checkAjax["PaparaCheckSession"] = false;
		}
	}
	$.ajax(
	{
		type: "POST",
		url:  "/Methods/Papara/Check",
		dataType: 'json',
        data : btoa(unescape(encodeURIComponent(JSON.stringify(jQuery("#PaparaDeposit").serializeArray())))),
		success : function(response){
			$('.loader').hide();
			if(response.valid == 0){
				swal.fire(response.validTitle, response.validMessage, response.validClass);
			}else{
				if(response.validCode == 200){
					var myHTMLdata = document.createElement("div");
					myHTMLdata.innerHTML = b64DecodeUnicode(response.base64Data);
					swal.fire({
						html: myHTMLdata,
						showCancelButton: false,
						showConfirmButton: false,
						allowOutsideClick: false,
						allowEscapeKey: false
					});
					window.checkAjaxFunction("PaparaOnline",5000,"PaparaOnline()");
				}else if(response.validCode == 211){
					if(first === true){
						swal.fire({
							type: response.validClass,
							title: response.validTitle,
							text: response.validMessage,
							showConfirmButton: false,
							allowOutsideClick: false,
							allowEscapeKey: false
						});
					}else{
						Swal.update({
							type: response.validClass,
							title: response.validTitle,
							text: response.validMessage
						});
					}
					window.checkAjaxFunction("PaparaCheckSession",5000,"PaparaCheckSession(false)");
				}else if(response.validCode == 252){ //failed transaction
					//swal.fire(response.validTitle, response.validMessage, response.validClass);
					swal.fire({
						type: response.validClass,
						title: response.validTitle,
						text: response.validMessage,
						//onClose: ReturnMainLink("R"),
                        confirmButtonText: 'Evet',
                        allowOutsideClick: false,
                        allowEscapeKey: false
					}).then((result) => {
                        if (result.value) {
                            ReturnMainLink("R");
                        } else if (
                            result.dismiss === Swal.DismissReason.cancel
                        ) {
                            ReturnMainLink("R");
                        }
                    });
				}else if(response.validCode == 253){ //confirmed transaction
					swal.fire({
						type: response.validClass,
						title: response.validTitle,
						text: response.validMessage,
						//onClose: ReturnMainLink("S"),
                        confirmButtonText: 'Evet',
                        allowOutsideClick: false,
                        allowEscapeKey: false
					}).then((result) => {
                        if (result.value) {
                            ReturnMainLink("S");
                        } else if (
                            result.dismiss === Swal.DismissReason.cancel
                        ) {
                            ReturnMainLink("S");
                        }
                    });
				}else if(response.validCode == 755){ //cancel transaction
                    swal.fire({
                        type: response.validClass,
                        title: response.validTitle,
                        text: response.validMessage,
                        showCancelButton: false,
                        showConfirmButton: false,
                        allowOutsideClick: false,
                        allowEscapeKey: false
                    });
                }else{
					swal.fire(response.validTitle, response.validMessage, response.validClass);
				}
			}
			console.log(response);
		},
		error: function(){
			//window.checkAjaxFunction("PaparaCheckSession",2500,"PaparaCheckSession()");
		}
	})
}

function PaparaCheckDid(){
	swal.close()
	$('.loader').css('display','flex');
	$.ajax(
	{
		type: "POST",
		url:  "/Methods/Papara/Check?action=did",
		dataType: 'json',
        data : btoa(unescape(encodeURIComponent(JSON.stringify(jQuery("#PaparaDeposit").serializeArray())))),
		success : function(response){
			if(response.valid == 0){
				swal.fire(response.validTitle, response.validMessage, response.validClass);
			}else{
				window.checkAjaxFunction("PaparaCheckSession",1000,"PaparaCheckSession()");
			}
			console.log(response);
		},
		error: function(){
			//window.checkAjaxFunction("PaparaCheckSession",2500,"PaparaCheckSession()");
		}
	})
}

function PaparaCheckDesist(){
	swal.close()
	$('.loader').css('display','flex');
	$.ajax(
	{
		type: "POST",
		url:  "/Methods/Papara/Check?action=desist",
		dataType: 'json',
        data : btoa(unescape(encodeURIComponent(JSON.stringify(jQuery("#PaparaDeposit").serializeArray())))),
		success : function(response){
			if(response.valid == 0){
				swal.fire(response.validTitle, response.validMessage, response.validClass);
			}else{
				window.checkAjaxFunction("PaparaCheckSession",1000,"PaparaCheckSession()");
			}
			console.log(response);
		},
		error: function(){
			//window.checkAjaxFunction("PaparaCheckSession",2500,"PaparaCheckSession()");
		}
	})
}

function PaparaOnline(){
	$.ajax({
		type: "POST",
		url: "/Methods/Papara/Check?action=online",
		dataType: 'json',
        data : btoa(unescape(encodeURIComponent(JSON.stringify(jQuery("#PaparaDeposit").serializeArray())))),
		success : function(response){
			if(response.validCode == 200){
				window.checkAjaxFunction("PaparaOnline",5000,"PaparaOnline()");
			}else if(response.valid == 0){
				// nothing
			}else{
				window.checkAjaxFunction("PaparaCheckSession",1000,"PaparaCheckSession()");
			}
		}
	})
}

$("#BankTransferDeposit").submit(function() {
	$('.loader').css('display','flex');
	$.ajax(
	{
		type: "POST",
		url:  "/Methods/BankTransfer/Pay",
		dataType: 'json',
		data : btoa(unescape(encodeURIComponent(JSON.stringify(jQuery("#BankTransferDeposit").serializeArray())))),
		success : function(response){
			$('.loader').hide();
			if(response.valid == 0){
				swal.fire(response.validTitle, response.validMessage, response.validClass);
			}else{
				swal.fire({
					type: response.validClass,
					title: response.validTitle,
					text: response.validMessage,
					showConfirmButton: false,
					allowOutsideClick: false,
					allowEscapeKey: false
				});
				window.checkAjaxFunction("BankTransferCheckSession",1000,"BankTransferCheckSession()");
			}
			console.log(response);
		}
	})

});

function BankTransferCheckSession(first){
	first = typeof first === 'undefined' ? true : first;
	if(first === true){
		if(window.checkAjax["BankTransferCheckSession"] !== false){
			clearTimeout(window.checkAjax["BankTransferCheckSession"]);
			window.checkAjax["BankTransferCheckSession"] = false;
		}
	}
	$.ajax(
	{
		type: "POST",
		url:  "/Methods/BankTransfer/Check",
		dataType: 'json',
        data : btoa(unescape(encodeURIComponent(JSON.stringify(jQuery("#BankTransferDeposit").serializeArray())))),
		success : function(response){
			$('.loader').hide();
			if(response.valid == 0){
				swal.fire(response.validTitle, response.validMessage, response.validClass);
			}else{
				if(response.validCode == 200){
					var myHTMLdata = document.createElement("div");
					myHTMLdata.innerHTML = b64DecodeUnicode(response.base64Data);
					if(first === true){
						swal.fire({
							html: myHTMLdata,
							showCancelButton: false,
							showConfirmButton: false,
							allowOutsideClick: false,
							allowEscapeKey: false
						});
					}else{
						Swal.update({html:b64DecodeUnicode(response.base64Data)});
					}
					window.checkAjaxFunction("BankTransferCheckSession",10000,"BankTransferCheckSession(false)");
				}else if(response.validCode == 205 || response.validCode == 290 || response.validCode == 291){
					if(first === true){
						swal.fire({
							type: response.validClass,
							title: response.validTitle,
							text: response.validMessage,
							showConfirmButton: false,
							allowOutsideClick: false,
							allowEscapeKey: false
						});
					}else{
						Swal.update({
							type: response.validClass,
							title: response.validTitle,
							text: response.validMessage
						});
					}
					window.checkAjaxFunction("BankTransferCheckSession",2500,"BankTransferCheckSession(false)");
				}else if(response.validCode == 252){ //failed transaction
                    swal.fire({
                        type: response.validClass,
                        title: response.validTitle,
                        text: response.validMessage,
                        //onClose: ReturnMainLink("S"),
                        confirmButtonText: 'Evet',
                        allowOutsideClick: false,
                        allowEscapeKey: false
                    }).then((result) => {
                        if (result.value) {
                            ReturnMainLink("R");
                        } else if (
                            result.dismiss === Swal.DismissReason.cancel
                        ) {
                            ReturnMainLink("R");
                        }
                    });
				}else if(response.validCode == 253){ //confirmed transaction
					swal.fire({
						type: response.validClass,
						title: response.validTitle,
						text: response.validMessage,
						//onClose: ReturnMainLink("S"),
                        confirmButtonText: 'Evet',
                        allowOutsideClick: false,
                        allowEscapeKey: false
					}).then((result) => {
                        if (result.value) {
                            ReturnMainLink("S");
                        } else if (
                            result.dismiss === Swal.DismissReason.cancel
                        ) {
                            ReturnMainLink("S");
                        }
                    });
				}else if(response.validCode == 755){ //cancel transaction
                    swal.fire({
                        type: response.validClass,
                        title: response.validTitle,
                        text: response.validMessage,
                        showCancelButton: false,
                        showConfirmButton: false,
                        allowOutsideClick: false,
                        allowEscapeKey: false
                    });
                }else{
					swal.fire(response.validTitle, response.validMessage, response.validClass);
				}
			}
			console.log(response);
		},
		error: function(){
			//window.checkAjaxFunction("BankTransferCheckSession",2500,"BankTransferCheckSession()");
		}
	})
}

function BankTransferCheckDid(){
	swal.close()
	$('.loader').css('display','flex');
	$.ajax(
	{
		type: "POST",
		url:  "/Methods/BankTransfer/Check?action=did",
		dataType: 'json',
        data : btoa(unescape(encodeURIComponent(JSON.stringify(jQuery("#BankTransferDeposit").serializeArray())))),
		success : function(response){
			if(response.valid == 0){
				swal.fire(response.validTitle, response.validMessage, response.validClass);
			}else{
				window.checkAjaxFunction("BankTransferCheckSession",1000,"BankTransferCheckSession()");
			}
			console.log(response);
		},
		error: function(){
			//window.checkAjaxFunction("BankTransferCheckSession",2500,"BankTransferCheckSession()");
		}
	})
}

function BankTransferCheckDesist(){
	swal.close()
	$('.loader').css('display','flex');
	$.ajax(
	{
		type: "POST",
		url:  "/Methods/BankTransfer/Check?action=desist",
		dataType: 'json',
        data : btoa(unescape(encodeURIComponent(JSON.stringify(jQuery("#BankTransferDeposit").serializeArray())))),
		success : function(response){
			if(response.valid == 0){
				swal.fire(response.validTitle, response.validMessage, response.validClass);
			}else{
				window.checkAjaxFunction("BankTransferCheckSession",1000,"BankTransferCheckSession()");
			}
			console.log(response);
		},
		error: function(){
			//window.checkAjaxFunction("PaparaCheckSession",2500,"PaparaCheckSession()");
		}
	})
}

function ReturnMainLink(isStatus){
	var ReturnURL = '';
	if(isStatus == 'S'){
		var ReturnURL = $('meta[name=return_url]').attr('content');;
	}else if(isStatus == 'R'){
		var ReturnURL = $('meta[name=return_url]').attr('content');;
	}else{
		var ReturnURL = $('meta[name=return_url]').attr('content');;
	}
	if(ReturnURL == null || ReturnURL == ''){
		var ReturnURL = $('meta[name=return_url]').attr('content');;
	}
	if(ReturnURL != null){
		if(ReturnURL != ''){
			var urlProtocol = ReturnURL.indexOf("://");
			if(urlProtocol > -1){
				window.location = ReturnURL;
			}else{
				window.location = "http://"+ReturnURL;
				//window.close();
			}
		}
	}
}
