# PaPara for Deposit

---

This service allows merchants to send payment to customers.

<h3>Endpoint</h3>
<pre><code class="language-php">POST https://{{ env('PAYMENT_URL') }}/payment/deposit/papara</code></pre>

<h3>Params</h3>

| Parameter | Type | Description | Requirement |
| : |   :   |  :  |  :  |
| api_id | integer | API Id for Merchant | Yes |
| api_key | string | API Key for Merchant | Yes |
| user_id | integer | User Id that started the process | Yes |
| username | string | Username that started the process | Yes |
| external_transaction_id | string | Unique ID submitted by the site | No |
| first_name | string | First name that started the process | Yes |
| last_name | string | Last name that started the process | Yes |
| lang | string | System Language Code | Yes |
| currency | string | System Currency Code | Yes |
| email | string | Email that started the process | No |
| phone_number | string | Phone number that started the process | No |
| tcno | string | Identity number that started the process | No |
| return_url_success | string | The url to be redirected after successful completion of the transaction | No |
| return_url_fail | string | The url to be redirected after fail completion of the transaction | No |

<h3>Response</h3>
```javascript
{
    "code": 200,
    "type": "success",
    "message": "Your request has been received.",
    "url": "//{{ env('PAYMENT_URL') }}/pay/3?hash=9eNhXm40VI1faX2eoqZFd7nncRYf3JLCo3be0eO923xFNAnaOF",
    "method_id": 1,
    "transaction_id": 123456789,
    "hash": "9eNhXm40VI1faX2eoqZFd7nncRYf3JLCo3be0eO923xFNAnaOF"
}
```

<h3>Example PHP Code</h3>

```php
$parameters = [
    'api_id' => 1,
    'api_key' => 'x3dfjkasdo12332',
    'user_id' => 1,
    'username' => 'pay_test',
    'external_transaction_id' => '5f08479c847733826ad5e4c1',
    'first_name' => 'Payment',
    'last_name' => 'Test',
    'amount' => 200.00,
    'lang' => 'tr',
    'currency' => 'TRY',
];

$url = 'https://{{ env('PAYMENT_URL') }}/payment/deposit/papara';
$fields_string = http_build_query($parameters);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
$response = curl_exec($ch);
curl_close($ch);

$json = json_decode($response);

if ($json->code == 200) {
    $iframeUrl = $json->url;

    echo $iframeUrl;
} else {
    echo 'Deposit request was rejected.';
}
```
