# Bank List for Bank Transfer

---

<p>This api service allows you to fill your bank_id field for a payment request. You can give the banks listed below as the bank_id parameter to be used in the Bank Transfer method. Otherwise, deposit / withdrawal transactions can be considered canceled as other provided id and bank names are different in your system.</p>

<h3>Endpoint</h3>
<pre><code class="language-php">POST https://{{ env('PAYMENT_URL') }}/payment/api/banks</code></pre>

<h3>Params</h3>

| Parameter | Type | Description | Requirement |
| : |   :   |  :  |  :  |
| api_id | integer | API Id for Merchant | Yes |
| api_key | string | API Key for Merchant | Yes |
| lang | string | System Language Code | Yes |
| currency | string | System Currency Code | Yes |

<h3>Response</h3>
```javascript
{
    "code": 200,
    "type": "success",
    "message": "Your request has been received.",
    "banks": [
        {
            "id": 2,
            "name": "AkBank",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-04-16 01:15:08"
        },
        {
            "id": 3,
            "name": "DenizBank",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-04-16 01:15:00"
        },
        {
            "id": 4,
            "name": "FinansBank",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-03-21 20:04:32"
        },
        {
            "id": 5,
            "name": "Halk Bankası",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-03-21 20:04:57"
        },
        {
            "id": 6,
            "name": "İş Bankası",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-03-21 20:05:11"
        },
        {
            "id": 7,
            "name": "Teb Bankası",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-04-16 01:14:49"
        },
        {
            "id": 8,
            "name": "YapıKredi",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-04-16 01:14:42"
        },
        {
            "id": 9,
            "name": "Ziraat Bankası",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-04-16 01:14:36"
        },
        {
            "id": 10,
            "name": "VakıfBank",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-04-16 01:14:30"
        },
        {
            "id": 11,
            "name": "ING Bank",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-04-16 01:14:24"
        },
        {
            "id": 12,
            "name": "Şeker Bank",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-04-16 01:14:17"
        },
        {
            "id": 13,
            "name": "PTT",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-04-16 01:14:11"
        },
        {
            "id": 14,
            "name": "Albaraka",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-04-16 01:14:05"
        },
        {
            "id": 15,
            "name": "Kuvey Türk",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-04-16 01:13:56"
        },
        {
            "id": 18,
            "name": "EnPara",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-04-16 01:12:43"
        },
        {
            "id": 19,
            "name": "Türkiye Finans",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-04-18 17:21:10"
        },
        {
            "id": 20,
            "name": "Garanti Bankası",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-04-20 14:49:12"
        },
        {
            "id": 22,
            "name": "Alternatif Bank",
            "mobile_bank_status": 0,
            "param_status": 0,
            "updated_at": "2020-08-30 01:20:47"
        }
    ]
}
```

<h3>Example PHP Code</h3>

```php
$parameters = [
    'api_id' => 1,
    'api_key' => 'x3dfjkasdo12332',
    'lang' => 'tr',
    'currency' => 'TRY',
];

$url = 'https://{{ env('PAYMENT_URL') }}/payment/api/banks';
$fields_string = http_build_query($parameters);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HEADER, false);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
$response = curl_exec($ch);
curl_close($ch);

$json = json_decode($response);

if ($json->code == 200) {
    $bankList = $json->banks;

    echo '<pre>'; print_r($bankList);
} else {
    echo 'Bank List request was rejected.';
}
```
