<?php
/**
 * Created by PhpStorm.
 * Filename: SxController.php
 * Description:
 * User: orhanbhr
 * Date: 08/09/23
 * Time: 3:08 PM
 */

namespace App\Http\Controllers;

use App\BankAccount;
use App\CronJob;
use App\DepositRange;
use App\SxLog;
use App\SxTransaction;
use App\Transaction;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SxController extends Controller
{
    /**
     * @param Request $request
     * @return void
     */
    public function index(Request $request)
    {
        $message = $request->input('message');
        $chatId = $request->input('chat_id');

        # Add Sx Log
        SxLog::addLog($chatId, $message);

        # Check Sx Transaction for DB Save
        if (Str::contains($message, '💸 *GELEN ÖDEME* 💸')) {
            $data = explode("\n", trim(str_replace('`', '', explode('💸 *GELEN ÖDEME* 💸', $message)[1])));
            $regexNameAndMoney = explode(' aşağıdaki hesaba ', $data[0]);
            $senderName = trim($regexNameAndMoney[0]);
            //$money = trim(str_replace('TL gönderdi.', '', $regexNameAndMoney[1]));
            $regexCurrency = explode(' ', $regexNameAndMoney[1]);
            $regexReceiver = explode(' - ', trim($data[1]));
            $currency = trim($regexCurrency[1]);
            $amount = $this->convertSxMoney(trim($regexCurrency[0]));
            $receiverAccountNumber = $regexReceiver[0];
            $receiverAccountName = $regexReceiver[1];

            # Check Account Interruption
            if (!empty($data[2])) {
                if (Str::contains($data[2], '*HESAPTA KESİNTİ VAR!*')) {
                    $isInterruption = 1;
                } else {
                    $isInterruption = 0;
                }
            } else {
                $isInterruption = 0;
            }

            # Check Description
            if (Str::contains($data[0], 'açıklama ekledi:')) {
                $regexDescription = explode('açıklama ekledi:', $regexNameAndMoney[1]);
                $description = trim($regexDescription[1] ?? '');
            } else {
                $description = '';
            }

            if (Str::contains($senderName, '***')) {
                $isHiddenName = 1;
            } else {
                $isHiddenName = 0;
            }

            # Insert Sx Transaction
            $sxTransactionId = SxTransaction::addTransaction(
                $senderName,
                $amount,
                $receiverAccountNumber,
                $receiverAccountName,
                $currency,
                $isInterruption,
                $description,
                $isHiddenName
            );

            # Sx Match BankId Cron Job Run
            if (!empty($sxTransactionId)) {
                runCronJob(2, ['transactionId' => $sxTransactionId]);
            }
        }
    }

    public function checkAccountSite($apiId, $query)
    {
        foreach ($query as $key => $q) {
            $explodeApiId = explode(',', $q->api_id);

            if (!in_array($apiId, $explodeApiId)) {
                unset($query[$key]);
            }
        }

        return $query;
    }



    /**
     * @param $bankAccount
     * @return array
     */
    private function getCheckLimit($bankAccount)
    {
        $dataBankAccounts = [];

        if (!empty($bankAccount->process_limit) && $bankAccount->process_limit > 0) {
            if ($bankAccount->process_limit > Transaction::getCountProcessLimit($bankAccount->id)) {
                $dataBankAccounts = [
                    'id' => $bankAccount->id
                ];
            }
        } else {
            if (
                $bankAccount->total_limit > Transaction::getSumTotalLimit($bankAccount->id) &&
                $bankAccount->daily_limit > Transaction::getSumDailyLimit($bankAccount->id)
            ) {
                $dataBankAccounts = [
                    'id' => $bankAccount->id
                ];
            }
        }

        return $dataBankAccounts;
    }

    //private function depositRangeControl()

    public function test()
    {
        $amount = 100;
        $ids = '1';
        $getApiId = (int)$ids;
        $getActiveBankAccounts = BankAccount::query()
            ->where('type_id', 2)
            ->where('status', 1)
            //->whereIn('api_id', [0, $getApiId])
            //->whereIntegerInRaw('api_id', [$getApiId])
            //->whereRaw("api_id IN($ids)")
            //->where('api_id', 'LIKE', "%$getApiId,")
            ->where('is_pp_iban', 1)
            ->select(
                'id',
                'api_id',
                'process_limit',
                'total_limit',
                'daily_limit',
                'deposit_range_id',
                'mail_server'
            )
            ->get();

        $getActiveBankAccounts = checkAccountSite($getApiId, $getActiveBankAccounts);

        $activeBankId = 0;
        $dataBankAccounts = [];
        foreach ($getActiveBankAccounts as $bankAccount) {
            // Eğer ki otomatik papara ise mail server seçimi boş ise atla
            if (env('PAPARA_TYPE') == 3 && empty($bankAccount->mail_server))
                continue;

            // Yatırım aralığı kontrol ediliyor
            if (!empty($bankAccount->deposit_range_id) && $bankAccount->deposit_range_id > 0) {
                $getDepositRange = DepositRange::getDepositRangeByAmount($amount);

                if (!empty($getDepositRange)) {
                    foreach ($getDepositRange as $depositRange) {
                        if ($bankAccount->deposit_range_id == $depositRange->id) {
                            $dataBankAccounts[] = $this->getCheckLimit($bankAccount);
                        }
                    }
                }
            } else {
                $dataBankAccounts[] = $this->getCheckLimit($bankAccount);
            }
        }

        if (!empty($dataBankAccounts) && $dataBankAccounts > 0) {
            shuffle($dataBankAccounts);
            $activeBankId = $dataBankAccounts[0];
        }

        echo '<pre>'; print_r($activeBankId);
        echo '<hr />';
        echo '<pre>'; print_r($getActiveBankAccounts); die;


        die;
        $getSxLogs = SxLog::query()
            ->where('id', 4021)
            ->orderBy('id', 'DESC')
            ->limit(10)
            ->get();

        foreach ($getSxLogs as $sxLog) {
            $message = json_decode($sxLog->content);

            if (Str::contains($message, '💸 *GELEN ÖDEME* 💸')) {
                $data = explode("\n", trim(str_replace('`', '', explode('💸 *GELEN ÖDEME* 💸', $message)[1])));
                $regexNameAndMoney = explode(' aşağıdaki hesaba ', $data[0]);
                $senderName = trim($regexNameAndMoney[0]);
                //$money = trim(str_replace('TL gönderdi.', '', $regexNameAndMoney[1]));
                $regexCurrency = explode(' ', $regexNameAndMoney[1]);
                $regexReceiver = explode(' - ', trim($data[1]));
                $currency = trim($regexCurrency[1]);
                $amount = $this->convertSxMoney(trim($regexCurrency[0]));
                $receiverAccountNumber = $regexReceiver[0];
                $receiverAccountName = $regexReceiver[1];

                # Check Account Interruption
                if (!empty($data[2])) {
                    if (Str::contains($data[2], '*HESAPTA KESİNTİ VAR!*')) {
                        $isInterruption = 1;
                    } else {
                        $isInterruption = 0;
                    }
                } else {
                    $isInterruption = 0;
                }

                # Check Description
                if (Str::contains($data[0], 'açıklama ekledi:')) {
                    $regexDescription = explode('açıklama ekledi:', $regexNameAndMoney[1]);
                    $description = trim($regexDescription[1] ?? '');
                } else {
                    $description = '';
                }

                echo '<pre>';
                echo $senderName;
                echo '<br />';
                echo $amount;
                echo '<br />';
                echo $receiverAccountNumber;
                echo '<br />';
                echo $receiverAccountName;
                echo '<br />';
                echo $isInterruption;
                echo '<br />';
                echo $currency;
                echo '<br />';
                echo $description;
                echo '<br />';

                /*SxTransaction::addTransaction(
                    $senderName,
                    $amount,
                    $receiverAccountNumber,
                    $receiverAccountName,
                    $currency,
                    $isInterruption
                );*/

                print_r($data);
                print_r($regexCurrency);
                print_r($regexNameAndMoney);
                echo '<br />';
                echo '<br />';
            }
        }


        /*
         *
        CREATE TABLE `gpapara_db`.`sx_transactions` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `transaction_id` INT NOT NULL DEFAULT 0,
  `sender_name` VARCHAR(255) NOT NULL,
  `amount` DECIMAL(22,2) NOT NULL DEFAULT 0,
  `receiver_account_number` VARCHAR(100) NOT NULL,
  `receiver_account_name` VARCHAR(255) NOT NULL,
  `status` TINYINT(1) NOT NULL DEFAULT 0,
  `is_interruption` TINYINT(1) NOT NULL DEFAULT 0,
  `internal_bank_account_id` INT NOT NULL DEFAULT 0,
  `user_id` INT NOT NULL DEFAULT 0,
  `is_approved` TINYINT(1) NOT NULL DEFAULT 0,
  `created_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE INDEX `id_UNIQUE` (`id` ASC));
         */


        /*echo $this->convertSxMoney(23.017);
        echo '<br />';
        echo $this->convertSxMoney(15.500);
        echo '<br />';
        echo $this->convertSxMoney(2.500);
        echo '<br />';
        echo $this->convertSxMoney(250);
        echo '<br />';

        echo $this->convertMoney(23.017);
        echo '<br />';
        echo $this->convertMoney(15.500);
        echo '<br />';
        echo $this->convertMoney(2.500);
        echo '<br />';
        echo $this->convertMoney(250);
        echo '<br />';
        echo $this->convertMoney(23.000);
        echo '<br />';
        echo $this->convertMoney('23.017.53');
        echo '<br />';
        echo $this->convertMoney('23,017.53');
        echo '<br />';
        echo $this->convertMoney('2,923,017.53');
        echo '<br />';
        echo $this->convertMoney('2,822,923,017.53');
        echo '<br />';
        echo $this->convertMoney(23.17);
        echo '<br />';
        echo $this->convertMoney(150);
        echo '<br />';
        echo $this->convertMoney(618.0);
        echo '<br />';*/

        /*echo $this->convertName('Şefik Özükötü');
        echo '<br />';
        echo $this->convertName('Şefik özükötü');
        echo '<br />';
        echo $this->convertName('tuncay yılmaz');
        echo '<br />';
        echo $this->convertName('Orhan BAHAR');
        echo '<br />';
        echo $this->convertName('Ömer Faruk Unutmaz');
        echo '<br />';
        echo $this->convertName('Ömer Faruk UNUTMAZ');
        echo '<br />';*/
    }

    /**
     * @param $value
     * @return string
     */
    public function convertMoney($value): string
    {
        $value = strval($value);
        $parts = explode('.', $value);
        $integerPart = isset($parts[0]) ? preg_replace("/[^0-9]/", "", $parts[0]) : '0';
        $decimalPart = $parts[1] ?? '00';
        $integerPart = str_replace(['.', ','], '', $integerPart);
        $decimalPart = str_pad($decimalPart, 2, '0');

        return $integerPart . '.' . $decimalPart;
    }

    /**
     * @param $value
     * @return string
     */
    public function convertSxMoney($value): string
    {
        $value = strval($value);
        $value = str_replace('.', '', $value);
        return str_replace(',', '.', $value);
    }
}
