<?php
/**
 * Created by PhpStorm.
 * Filename: PushBulletController.php
 * Description:
 * User: orhanbhr
 * Date: 12/10/20
 * Time: 3:08 PM
 */

namespace App\Http\Controllers;

use App\PushBulletSms;
use Carbon\Carbon;
use Illuminate\Http\Request;

class PushBulletController extends Controller
{
    public function pushApi(Request $request)
    {
        $text = $request->input('text') ?? [];
        $json = json_decode($text);
        $insertData = [];

        if (!empty($json->push->notifications)) {
            foreach ($json->push->notifications as $notification) {
                $insertData[] = [
                    'title' => $notification->title,
                    'text' => $notification->body,
                    'thread_id' => $notification->thread_id,
                    'targets' => implode(',', $json->targets),
                    'source_device_iden' => $json->push->source_device_iden,
                    'type' => $json->push->type,
                    'created_at' => Carbon::now(),
                    'updated_at' => Carbon::now()
                ];
            }
        }

        $insert = PushBulletSms::insert($insertData);

        if ($insert)
            return response()->json(['status' => true]);
        else
            return response()->json(['status' => true]);
    }
}
