<?php
/**
 * Created by PhpStorm.
 * Filename: IframeController.php
 * Description:
 * User: orhanbhr
 * Date: 2.11.2020
 * Time: 21:19
 */

namespace App\Http\Controllers;

use App\Player;
use Faker\Factory as Faker;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;

class IframeController extends Controller
{
    private $sites = [
        'gizabet' => [
            'id' => 3,
            'key' => 'r6A9nPsNDCJS7avLKg5CqBCkWDsfS0sC'
        ]
    ];

    private $payments = [
        3 => 'papara'
    ];

    /**
     * @param $siteName
     * @param $userId
     * @param Request $request
     * @return RedirectResponse|Redirector|string
     */
    public function index($siteName, $userId, Request $request)
    {
        $typeName = $request->input('type');
        $method = $request->input('method');
        $faker = Faker::create();

        if (empty($typeName) || empty($method))
            return 'Tip veya Method bilgisi girilmedi !';

        if ($userId != 2020088429941)
            return 'Şu anda aktif değildir. Lütfen canlı destek hattından bilgi alınız !';

        $checkUser = Player::where('api_id', $this->sites[$siteName]['id'])
            ->where('external_user_id', $userId)
            ->first();

        if (!empty($checkUser)) {
            $username = $checkUser->username;
            $externalUserId = $checkUser->external_user_id;
            $firstName = $checkUser->first_name;
            $lastName = $checkUser->last_name;
        } else {
            $username = $userId;
            $externalUserId = $userId;
            $firstName = $userId;
            $lastName = $userId;
        }

        $sendData = [
            'api_id' => $this->sites[$siteName]['id'],
            'api_key' => $this->sites[$siteName]['key'],
            'external_transaction_id' => $faker->uuid,
            'user_id' => $externalUserId,
            'username' => $username,
            'first_name' => $firstName,
            'last_name' => $lastName,
            'lang' => 'tr',
            'currency' => 'TRY'
        ];

        $post = SeamlessController::postData(
            url('/payment/' . $typeName . '/' . $this->payments[$method], [], true),
            $sendData
        );

        if (!empty($post['response']) && $post['response']->code == 200) {
            return redirect($post['response']->url);
        } else {
            return 'Şu anda aktif değildir. Lütfen canlı destek hattından bilgi alınız !';
        }
    }
}
