<?php

namespace App\Http\Controllers;

use App\BankAccount;
use App\CronJob;
use App\Log;
use App\RequestLog;
use App\SxTransaction;
use App\Transaction;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class CronJobController extends Controller
{
    /**
     * @return void
     */
    public function deleteEmptyTransactions(Request $request)
    {
        $userId = $request->input('userId') ?? 0;
        $date = Carbon::now()->addHours(-2);
        $getTransactions = Transaction::query()
            ->where('amount', 0)
            ->where('is_success', 0)
            ->where('created_at', '<', $date)
            ->orderBy('id', 'DESC')
            ->get();

        echo 'Total: ' . count($getTransactions);

        foreach ($getTransactions as $transaction) {
            $transactionId = $transaction->id;

            $deleteTransaction = Transaction::query()
                ->where('id', $transactionId)
                ->delete();

            if ($deleteTransaction) {
                Log::addLog($userId, 31, 4, $transactionId);
            } else {
                Log::addLog($userId, 32, 4, $transactionId);
            }

        }

        CronJob::addCronJobLog($userId, 1);
    }

    /**
     * @param Request $request
     * @return void
     */
    public function sxMatchBankIds(Request $request)
    {
        $userId = $request->input('userId') ?? 0;
        $transactionId = $request->input('transactionId') ?? 0;
        $processedTransaction = 0;

        # Get Sx Transactions Pending BankAccountId Matching
        $getSxTransactions = new SxTransaction();
        $getSxTransactions = $getSxTransactions->query();

        if (!empty($transactionId))
            $getSxTransactions = $getSxTransactions->where('id', (int)$transactionId);

        $getSxTransactions = $getSxTransactions->where('internal_bank_account_id', 0);
        $getSxTransactions = $getSxTransactions->where('status', 0);
        $getSxTransactions = $getSxTransactions->orderBy('id', 'DESC');
        $getSxTransactions = $getSxTransactions->get();

        echo 'Total: ' . count($getSxTransactions);

        $dataBankAccounts = [];
        $getBankAccounts = BankAccount::query()
            ->where('type_id', 2)
            ->orderBy('id', 'DESC')
            ->get();

        # Parse Bank Accounts
        foreach ($getBankAccounts as $bankAccount) {
            if (!empty($bankAccount->account_owner))
                $dataBankAccounts[$bankAccount->account_number] = $bankAccount->id;
        }

        foreach ($getSxTransactions as $sxTransaction) {
            $getBankAccount = BankAccount::query()
                ->where('account_number', $sxTransaction->receiver_account_number)
                ->where('status', 1)
                ->orderBy('id', 'DESC')
                ->first();

            if (!empty($getBankAccount)) {
                $updateSxTransaction = SxTransaction::updateBankAccountId($sxTransaction->id, $getBankAccount->id);

                if ($updateSxTransaction) {
                    Log::addLog($userId, 33, 12, $sxTransaction->id);

                    # Sx Match TransactionId Cron Job Run
                    runCronJob(3, ['transactionId' => $sxTransaction->id]);

                    $processedTransaction++;
                }
            } else {
                if (!empty($dataBankAccounts) && !empty($dataBankAccounts[$sxTransaction->receiver_account_number])) {
                    $updateSxTransaction = SxTransaction::updateBankAccountId(
                        $sxTransaction->id,
                        $dataBankAccounts[$sxTransaction->receiver_account_number]
                    );

                    if ($updateSxTransaction) {
                        Log::addLog($userId, 33, 12, $sxTransaction->id);

                        # Sx Match TransactionId Cron Job Run
                        runCronJob(3, ['transactionId' => $sxTransaction->id]);

                        $processedTransaction++;
                    } else {
                        Log::addLog($userId, 34, 12, $sxTransaction->id);
                    }
                } else {
                    SxTransaction::query()
                        ->where('id', $sxTransaction->id)
                        ->update([
                            'status' => 2,
                            'updated_at' => Carbon::now()
                        ]);
                }
            }
        }

        CronJob::addCronJobLog($userId, 2);

        echo '<br />';
        echo 'Processed Transaction: ' . $processedTransaction;
    }

    /**
     * @param Request $request
     * @return void
     */
    public function sxMatchTransactionIds(Request $request)
    {
        $dataTransactions = [];
        $userId = $request->input('userId') ?? 0;
        $transactionId = $request->input('transactionId') ?? 0;

        # Get Sx Transactions Pending TransactionId Matching
        $getSxTransactions = new SxTransaction();
        $getSxTransactions = $getSxTransactions::query();
        $getSxTransactions = $getSxTransactions->where('status', 0);
        $getSxTransactions = $getSxTransactions->where('internal_bank_account_id', '!=', 0);
        $getSxTransactions = $getSxTransactions->where('transaction_id', 0);

        if (!empty($transactionId))
            $getSxTransactions = $getSxTransactions->where('id', (int)$transactionId);

        $getSxTransactions = $getSxTransactions->orderBy('id', 'DESC');
        $getSxTransactions = $getSxTransactions->limit(200);
        $getSxTransactions = $getSxTransactions->get();

        echo 'Total: ' . count($getSxTransactions);

        $getPendingTransactions = Transaction::query()
            ->with('player')
            #->where('api_id', '!=', 29)
            ->where('transaction_type', 3)
            ->where('player_approved', 1)
            ->where('is_success', 0)
            #->where('id', 4641930)
            #->where('id', '>', 4641930)
            #->where('id', '<', 4641940)
            ->where('amount', '>', 0)
            ->orderBy('id', 'DESC')
            #->limit(5000)
            ->get();

        # Convert Pending Transaction Array
        /*foreach ($getPendingTransactions as $pendingTransaction) {
            if (!empty($pendingTransaction->sx_match_name)) {
                $dataTransactions[$pendingTransaction->sx_match_name] = $pendingTransaction;
            } else {
                $fullName = sxConvertName(
                    $pendingTransaction->player->first_name . ' ' . $pendingTransaction->player->last_name
                );
                $dataTransactions[$fullName] = $pendingTransaction;
            }
        }*/

        echo sxCreateHiddenName('Orhan BAHAR');
        echo '<br />';
        echo sxCreateHiddenName('Murat Can BAHAR');
        echo '<br />';
        echo sxCreateHiddenName('Ömer Can Keçeci');
        echo '<br />';
        echo sxCreateHiddenName('ömer Süleyman Can Hakverir');
        echo '<br />';
        echo sxCreateHiddenName('Ali Özgün Çervatoğlu');
        echo '<br />';
        echo sxCreateHiddenName('A*** Ö*** Ç***');
        echo '<br />';
        echo sxConvertName('Mehmet Melih Yaktı');
        echo '<br />';
        echo sxConvertName('mehmet melih yaktı');
        echo '<br />';
        echo sxCreateFirstAndLastName('mehmet melih yaktı');
        echo '<br />';
        echo sxCreateFirstAndLastName('Ümit Berkay Turan');
        echo '<br />';
        echo sxCreateFirstAndLastName('Ümit Berkay Ahmet Turan');
        echo '<br />';
        echo sxCreateFirstAndLastName('Ümit Berkay Ahmet fetin Turan');
        echo '<br />';
        echo sxCreateFirstAndLastName('Ümit Berkay Ahmet fetin Kemal');
        echo '<br />';
        echo sxCountName('mehmet melih yaktı');
        echo '<br />';
        echo sxCountName('Ümit Berkay Turan');
        echo '<br />';
        echo sxCountName('Ümit Turan');
        echo '<br />';
        echo sxCountName('Ümit Berkay Ahmet Turan');
        echo '<br />';
        echo sxCountName('Ümit Berkay Ahmet fetin Turan');
        echo '<br />';
        echo sxCountName('Ümit Berkay Ahmet fetin Kemal');
        echo '<br />';
        echo '<br />';
        echo '<br />';

        #echo runCronJob(1, ['userId' => 2]);


        #echo '<pre>';print_r($getPendingTransactions);

        foreach ($getSxTransactions as $sxTransaction) {
            #echo '<pre>';print_r($sxTransaction);

            $matchTransaction = $this->matchPendingTransaction(
                $getPendingTransactions,
                $sxTransaction->sender_name,
                $sxTransaction->amount,
                $sxTransaction->is_hidden_name,
                $sxTransaction->internal_bank_account_id
            );

            if ($matchTransaction['status'] === true) {
                SxTransaction::query()
                    ->where('id', $sxTransaction->id)
                    ->update([
                        'transaction_id' => $matchTransaction['transaction_id'],
                        'status' => 1,
                        'updated_at' => Carbon::now()
                    ]);

                # Sx Run CallBack Cron Job Run
                #runCronJob(5, ['transactionId' => $sxTransaction->id]);
            } else {
                // eşleşen kayıt bulunamadı.... burayı düşüneceğiz...
            }

            echo $sxTransaction->id;
            echo '<pre>'; print_r($matchTransaction); echo '<br />';
        }

        CronJob::addCronJobLog($userId, 3);
    }

    /**
     * @param Request $request
     * @return void
     */
    public function sxCheckVaultTransfer(Request $request)
    {
        $userId = $request->input('userId') ?? 0;

        # Get Sx Transactions Pending Vault Transfer Matching
        $getSxTransactions = new SxTransaction();
        $getSxTransactions = $getSxTransactions::query();
        $getSxTransactions = $getSxTransactions->where('internal_bank_account_id', '!=', 0);
        $getSxTransactions = $getSxTransactions->where('status', 0);
        $getSxTransactions = $getSxTransactions->orderBy('id', 'DESC');
        $getSxTransactions = $getSxTransactions->get();

        echo 'Total: ' . count($getSxTransactions);

        $processedTransaction = 0;
        $dataBankAccounts = [];
        $getBankAccounts = BankAccount::query()
            ->where('type_id', 2)
            ->orderBy('id', 'DESC')
            ->get();

        # Parse Bank Accounts
        foreach ($getBankAccounts as $bankAccount) {
            if (!empty($bankAccount->account_owner))
                $dataBankAccounts[$bankAccount->account_owner] = $bankAccount;
        }

        # Matching Sx Transactions
        foreach ($getSxTransactions as $sxTransaction) {
            if (!empty($dataBankAccounts[$sxTransaction->sender_name])) {
                $updateSxTransaction = SxTransaction::query()
                    ->where('id', $sxTransaction->id)
                    ->update([
                        'status' => 2,
                        'updated_at' => Carbon::now()
                    ]);

                if ($updateSxTransaction) {
                    $processedTransaction++;
                }
            }
        }

        echo '<br />';
        echo 'Processed Transaction: ' . $processedTransaction;

        CronJob::addCronJobLog($userId, 4);
    }

    /**
     * @param Request $request
     * @return void
     */
    public function sxRunCallBack(Request $request)
    {
        $userId = $request->input('userId') ?? 0;
        $transactionId = $request->input('transactionId') ?? 0;
        $processedTransaction = 0;

        # Check Sx Status
        if (env('SX_STATUS') == 0) {
            echo 'SX STATUS DISABLED';
            die;
        }

        # Get Sx Transactions Pending Vault Transfer Matching
        $getSxTransactions = new SxTransaction();
        $getSxTransactions = $getSxTransactions::query();
        $getSxTransactions = $getSxTransactions->where('internal_bank_account_id', '!=', 0);

        if (!empty($transactionId))
            $getSxTransactions = $getSxTransactions->where('transaction_id', (int)$transactionId);
        else
            $getSxTransactions = $getSxTransactions->where('transaction_id', '!=', 0);

        $getSxTransactions = $getSxTransactions->where('status', 1);
        $getSxTransactions = $getSxTransactions->where('is_approved', 0);
        $getSxTransactions = $getSxTransactions->orderBy('id', 'DESC');
        $getSxTransactions = $getSxTransactions->get();

        echo 'Total: ' . count($getSxTransactions);

        foreach ($getSxTransactions as $sxTransaction) {
            $runCallBack = $this->sendCallBack(
                $sxTransaction->transaction_id,
                (1),
                $userId,
                $sxTransaction->amount,
                (false)
            );

            if ($runCallBack['status']) {
                $updateTransaction = SxTransaction::query()
                    ->where('id', $sxTransaction->id)
                    ->update([
                        'user_id' => $userId,
                        'is_approved' => 1,
                        'updated_at' => Carbon::now()
                    ]);

                if ($updateTransaction) {
                    Log::addLog($userId, 35, 12, $sxTransaction->id);
                    $processedTransaction++;
                }
            }
        }

        CronJob::addCronJobLog($userId, 5);

        echo '<br />';
        echo 'Processed Transaction: ' . $processedTransaction;
    }

    /**
     * @param Request $request
     * @return void
     */
    public function declinedAutoTransactions(Request $request)
    {
        $userId = $request->input('userId') ?? 0;
        $transactionId = $request->input('transactionId') ?? 0;
        $processedTransaction = 0;

        # Check Sx Status
        if (env('SX_STATUS') == 0) {
            echo 'SX STATUS DISABLED';
            die;
        }

        $getTransactions = new Transaction();
        $getTransactions = $getTransactions::query();
        $getTransactions = $getTransactions->where('transaction_type', 3);
        $getTransactions = $getTransactions->where('is_success', 0);
        $getTransactions = $getTransactions->where('player_approved', 1);
        $getTransactions = $getTransactions->orderBy('id', 'DESC');
        $getTransactions = $getTransactions->get();

        echo 'Total: ' . count($getTransactions);

        foreach ($getTransactions as $transaction) {
            if (Carbon::parse($transaction->created_at)->diffInMinutes(Carbon::now()) > 10) {
                $runCallBack = $this->sendCallBack(
                    $transaction->id,
                    (0),
                    $userId,
                    $transaction->amount,
                    (true)
                );

                if ($runCallBack['status']) {
                    $processedTransaction++;
                }
            }
        }

        CronJob::addCronJobLog($userId, 6);

        echo '<br />';
        echo 'Processed Transaction: ' . $processedTransaction;
    }

    /**
     * @param $transactionId
     * @param $status
     * @param $userId
     * @param $amount
     * @param $isDeclined
     * @return array
     */
    private function sendCallBack($transactionId, $status, $userId, $amount, $isDeclined): array
    {
        $getTransaction = Transaction::query()->where('id', (int)$transactionId)->first();
        $extraParams = json_decode($getTransaction->transaction_send_data);
        $paymentMethod = $getTransaction->payment_method ?? null;
        $site = $getTransaction->sites ?? null;
        $paymentType = $paymentMethod->type == 1 ? 'deposit' : 'withdraw';

        # If this process has been done before, it will not be done again.
        if ($getTransaction->is_success == $status && !$isDeclined)
            return [
                'status' => false,
            ];

        # If the transaction is set to being manually controlled, do not take any action.
        if ($getTransaction->is_success == 3)
            return [
                'status' => false,
            ];

        # Find Bank AccountId
        if (!empty($getTransaction->share_bank_account_id)) {
            $bankAccountId = $getTransaction->share_bank_account_id;
        } else {
            if (!empty($getTransaction->bank_account_id)) {
                $bankAccountId = $getTransaction->bank_account_id;
            } else {
                $bankAccountId = null;
            }
        }

        # If the seamless URL is empty or #, the process should be completed automatically.
        if (empty($site->seamless_url) || $site->seamless_url == '#') {
            $transactionUpdateStatus = true;
        } else {
            if (!empty($getTransaction->hash)) {
                # Seamless (CallBack) Send Request
                $parameters = [
                    'apiId' => $site->id,
                    'apiKey' => $site->code,
                    'paymentId' => $getTransaction->id,
                    'externalTransactionId' => $getTransaction->external_transaction_id,
                    'userId' => $getTransaction->player->external_user_id,
                    'username' => $getTransaction->player->username,
                    'type' => $paymentType,
                    'amount' => $amount,
                    'status' => $status == 1 ? true : false,
                    'message' => 'success',
                    'hash' => $getTransaction->hash
                ];
                $postData = SeamlessController::postData($site->seamless_url, $parameters);

                # Add Request Log
                RequestLog::addLog(
                    $transactionId,
                    $userId,
                    (2),
                    $parameters,
                    $postData['response'],
                    $postData['time']
                );

                # Hash Calculate
                $hashCalculate = hashCalculate(
                    $site->id,
                    $site->code,
                    $getTransaction->player->external_user_id,
                    $getTransaction->player->username,
                    $amount,
                    $paymentType,
                    $getTransaction->external_transaction_id
                );

                // Error correction when multiple requests are sent is for ProNet Gaming platform.
                if ($site->platform === 3) {
                    $getRequestLog = RequestLog::query()
                        ->where('transaction_id', (int)$transactionId)
                        ->where('type_id', 2)
                        ->orderBy('id', 'ASC')
                        ->first();

                    if (!empty($getRequestLog)) {
                        $jsonRequestContent = json_decode($getRequestLog->response_content);

                        if (!empty($jsonRequestContent) && (int)$jsonRequestContent->status === 200) {
                            $transactionUpdateStatus = true;
                        } else {
                            return [
                                'status' => false,
                                'message' => 'Hata, Pronet Gaming tarafından kaynaklı sorun mevcuttur.',
                                'callback' => $postData['response'],
                                'parameters' => $parameters,
                                'hash' => $hashCalculate
                            ];
                        }
                    } else {
                        # Check Hash Calculate
                        if (!empty($postData['response']->status)) {
                            # Check Hash Empty
                            if (empty($postData['response']->hash))
                                return [
                                    'status' => false,
                                    'message' => 'Hata, callback tarafından gelen hash bulunmamaktadır.',
                                    'callback' => $postData['response'],
                                    'parameters' => $parameters,
                                    'hash' => $hashCalculate
                                ];

                            # Check Hash Calculate
                            if (!checkHash($postData['response']->hash, $hashCalculate))
                                return [
                                    'status' => false,
                                    'message' => 'Hata, callback tarafından gelen hash geçersizdir.',
                                    'callback' => $postData['response'],
                                    'parameters' => $parameters,
                                    'hash' => $hashCalculate
                                ];
                        }

                        if (!empty($postData['response']->status) && $postData['response']->status == 200) {
                            $transactionUpdateStatus = true;
                        } else if (!empty($postData['response']->status) && $postData['response']->status == 201) {
                            $transactionUpdateStatus = true;
                        } else {
                            $transactionUpdateStatus = false;
                        }
                    }
                } else {
                    # Check Hash Calculate
                    if (!empty($postData['response']->status)) {
                        # Check Hash Empty
                        if (empty($postData['response']->hash))
                            return [
                                'status' => false,
                                'message' => 'Hata, callback tarafından gelen hash bulunmamaktadır.',
                                'callback' => $postData['response'],
                                'parameters' => $parameters,
                                'hash' => $hashCalculate
                            ];

                        # Check Hash Calculate
                        if (!checkHash($postData['response']->hash, $hashCalculate))
                            return [
                                'status' => false,
                                'message' => 'Hata, callback tarafından gelen hash geçersizdir.',
                                'callback' => $postData['response'],
                                'parameters' => $parameters,
                                'hash' => $hashCalculate
                            ];
                    }

                    if (!empty($postData['response']->status) && $postData['response']->status == 200) {
                        $transactionUpdateStatus = true;
                    } else if (!empty($postData['response']->status) && $postData['response']->status == 201) {
                        $transactionUpdateStatus = true;
                    } else {
                        $transactionUpdateStatus = false;
                    }
                }
            } else {
                $transactionUpdateStatus = false;
            }
        }

        # We update after the transaction check is completed.
        if ($transactionUpdateStatus) {
            $updateTransaction = Transaction::query()
                ->where('id', (int)$transactionId)
                ->update([
                    'is_success' => $status == 0 ? 2 : $status,
                    'amount' => $amount,
                    'pay_note' => 'Sx Tarafından İşlem Yapılmıştır.',
                    'user_id' => $userId
                ]);
        } else {
            $updateTransaction = false;
        }

        # After the updated transaction is completed, we create the bank balance and log records.
        if ($updateTransaction) {
            # If the status is not in progress.
            if ($status != 3) {
                if ($paymentMethod->type == 1) {
                    if ($status == 1)
                        BankAccount::addBankBalance($bankAccountId, $getTransaction->amount);
                } else if ($paymentMethod->type == 2) {
                    if ($status == 1)
                        BankAccount::removeBankBalance($bankAccountId, $getTransaction->amount);
                }
            }

            Log::addLog($userId, 9, 4, $transactionId);

            return [
                'status' => true,
            ];
        } else {
            return [
                'status' => false,
            ];
        }
    }

    /**
     * @param $data
     * @param $name
     * @param $amount
     * @param $isHiddenName
     * @param $bankAccountId
     * @return array
     */
    private function matchPendingTransaction($data, $name, $amount, $isHiddenName, $bankAccountId): array
    {
        if (empty($data))
            return [
                'status' => false
            ];

        #echo '<pre>';print_r($data);

        foreach ($data as $v) {
            $sxMatchName = $v->player->sx_match_name ?? null;
            $fullName = sxConvertName($v->player->first_name . ' ' . $v->player->last_name);
            $saltHiddenName = sxCreateHiddenName($v->player->first_name . ' ' . $v->player->last_name);
            $convertName = sxConvertName($name);
            $countName = sxCountName($name);
            $saltFirstAndLastName = sxCreateFirstAndLastName($name);
            $firstAndLastName = sxConvertName($saltFirstAndLastName);
            $saltPlayerName = sxCreateFirstAndLastName($v->player->first_name . ' ' . $v->player->last_name);
            $playerFirstAndLastName = sxConvertName($saltPlayerName);
            $countPlayerName = sxCountName($v->player->first_name . ' ' . $v->player->last_name);

            if (!empty($sxMatchName)) {
                if ($isHiddenName == 1) {
                    if (Str::contains($sxMatchName, '***')) {
                        if (
                            $sxMatchName == $name &&
                            $amount == $v->amount &&
                            $bankAccountId == $v->share_bank_account_id
                        ) {
                            // sx match name ile onaylandı...
                            return [
                                'status' => true,
                                'transaction_id' => $v->id,
                                'sx_name' => $name,
                                'is_hidden_name' => $isHiddenName
                            ];
                        } else
                            continue;
                    } else {
                        if (
                            $saltHiddenName == $name &&
                            $amount == $v->amount &&
                            $bankAccountId == $v->share_bank_account_id
                        ) {
                            // onayla ve sx name düzelt..
                            return [
                                'status' => true,
                                'transaction_id' => $v->id,
                                'sx_name' => $name,
                                'is_hidden_name' => $isHiddenName
                            ];
                        } else
                            continue;
                    }
                } else {
                    if (
                        $sxMatchName == $convertName &&
                        $amount == $v->amount &&
                        $bankAccountId == $v->share_bank_account_id
                    ) {
                        // onayla ve sxname düzelt...
                        return [
                            'status' => true,
                            'transaction_id' => $v->id,
                            'sx_name' => $name,
                            'is_hidden_name' => $isHiddenName
                        ];
                    } else
                        continue;
                }
            } else {
                /*echo '('.$fullName.')';
                echo '<br />';
                echo '('.$convertName.')';
                echo '<br />';
                echo '('.$amount.')';
                echo '<br />';
                echo '('.$v->amount.')';
                echo '<br />';
                echo '('.$v->id.')';
                echo '<br />';
                echo '('.$bankAccountId.')';
                echo '<br />';
                echo '('.$v->share_bank_account_id.')';
                echo '<br />';*/
                if (
                    $fullName == $convertName &&
                    $amount == $v->amount &&
                    $bankAccountId == $v->share_bank_account_id
                ) {
                    // normal isim ile onaylandı ve sx match name girildi...
                    return [
                        'status' => true,
                        'transaction_id' => $v->id,
                        'sx_name' => $name,
                        'is_hidden_name' => $isHiddenName
                    ];
                } else {
                    if ($isHiddenName == 1) {
                        // eğer ki 1 ise kontrol edelim onay red yapalım...
                        if (
                            $saltHiddenName == $name &&
                            $amount == $v->amount &&
                            $bankAccountId == $v->share_bank_account_id
                        ) {
                            // onaylanacak ve sx name girilecek
                            return [
                                'status' => true,
                                'transaction_id' => $v->id,
                                'sx_name' => $name,
                                'is_hidden_name' => $isHiddenName
                            ];
                        } else
                            continue;
                    } else {
                        if (
                            $fullName == $firstAndLastName &&
                            $countName > 2 &&
                            $amount == $v->amount &&
                            $bankAccountId == $v->share_bank_account_id
                        ) {
                            return [
                                'status' => true,
                                'transaction_id' => $v->id,
                                'sx_name' => $name,
                                'is_hidden_name' => $isHiddenName
                            ];
                        } else {
                            if (
                                $playerFirstAndLastName == $convertName &&
                                $countPlayerName > 2 &&
                                $amount == $v->amount &&
                                $bankAccountId == $v->share_bank_account_id
                            ) {
                                return [
                                    'status' => true,
                                    'transaction_id' => $v->id,
                                    'sx_name' => $name,
                                    'is_hidden_name' => $isHiddenName
                                ];
                            } else {
                                if (
                                    $fullName == $convertName &&
                                    ($amount + 5) > $v->amount &&
                                    ($amount - 5) < $v->amount &&
                                    $bankAccountId == $v->share_bank_account_id
                                ) {
                                    return [
                                        'status' => true,
                                        'transaction_id' => $v->id,
                                        'sx_name' => $name,
                                        'is_hidden_name' => $isHiddenName
                                    ];
                                } else {
                                    if (
                                        $fullName == $convertName &&
                                        $amount == $v->amount
                                    ) {
                                        return [
                                            'status' => true,
                                            'transaction_id' => $v->id,
                                            'sx_name' => $name,
                                            'is_hidden_name' => $isHiddenName
                                        ];
                                    } else
                                        continue;
                                }
                            }
                        }
                    }
                }
            }
        }

        return [
            'status' => false
        ];
    }
}
