<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

class DepositRange extends Model
{
    protected $table = 'deposit_range';

    /**
     * @param $amount
     * @return Builder|Model|object|null
     */
    public static function findDepositRangeByAmount($amount)
    {
        return self::query()
            ->where('min', '<=', $amount)
            ->where('max', '>=', $amount)
            ->where('status', 1)
            //->inRandomOrder()
            ->first();
    }

    /**
     * @param $amount
     * @return Builder[]|Collection
     */
    public static function getDepositRangeByAmount($amount)
    {
        return self::query()
            ->where('min', '<=', $amount)
            ->where('max', '>=', $amount)
            ->where('status', 1)
            ->get();
    }
}
