<?php

namespace App;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CronJob extends Model
{
    protected $table = 'cron_jobs';

    private static $typeList = [
        1 => 'Boş Talepleri Temizleme',
        2 => 'Saklanax Banka Hesap Eşleştirmesi',
        3 => 'Saklanax Transaction/İşlem Eşleştirmesi',
        4 => 'Saklanax Kasa Aktarım Eşleştirmesi',
        5 => 'Saklanax Başarılı CallBack Gönderimleri',
        6 => 'Saklanax Başarısız CallBack Gönderimleri',
    ];

    /**
     * @return BelongsTo
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * @param $userId
     * @param $typeId
     * @return bool
     */
    public static function addCronJobLog(
      $userId,
      $typeId
    ): bool
    {
        return self::query()
            ->insert([
                'user_id' => $userId,
                'type_id' => $typeId,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now()
            ]);
    }

    /**
     * @param $typeId
     * @return string
     */
    public static function getType($typeId): string
    {
        if (!empty($typeId) && !empty(self::$typeList[$typeId])) {
            return self::$typeList[$typeId];
        } else {
            return '-';
        }
    }

    /**
     * @return array
     */
    public static function getTypeList(): array
    {
        return self::$typeList;
    }
}
